
//--------------
// un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;   
   matrix ViewInv:ViewInverse; 

//--------------
// Textures
//--------------
   texture cubeMapTX : ENVIRONMENT <string Name = "";  >;
   samplerCUBE cubeMap = sampler_state 
      {
	Texture = <cubeMapTX>;
   	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
 
      };

//--------------
// structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION;
 	float2 UV:TEXCOORD;
     };
   struct output
     {
 	float4 OPos:POSITION;
 	float3 View:TEXCOORD0; 
     };

//--------------
// vertex shader
//--------------
   output VS(input IN) 
    {
 	output OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
	OUT.View=(mul(IN.Pos,World)-ViewInv[3].xyz); 
	return OUT;
    }

//--------------
// pixel shader
//--------------
    float4 PS(output IN)  : COLOR
     {		
	float4 finalCol=1;
	finalCol.xyz=texCUBE(cubeMap,IN.View);
	return finalCol;
     }

//--------------
// techniques   
//--------------
    technique Sky
      {
 	pass p1
      {		
 	vertexShader = compile vs_2_0 VS(); 
 	pixelShader  = compile ps_2_0 PS();	
      }
      }

